#!/usr/bin/python
# -*- coding: utf-8 -*-
## File importFiebdc.py
## This file is part of pyArq-Presupuestos.
##
## Copyright (C) 2010-2019 Miguel Ángel Bárcena Rodríguez
##                         <miguelangel@obraencurso.es>
##
## pyArq-Presupuestos is free software: you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation, either version 3 of the License, or
## (at your option) any later version.
##
## pyArq-Presupuestos is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Modules

# python 2/3 compatibility
from __future__ import absolute_import, division, print_function, unicode_literals

# gui
import gi
gi.require_version('Gtk', '3.0')
from gi.repository import Gtk
from gi.repository import GLib

import threading

class Thread(threading.Thread):
    """importFiebdc.Thread:
    
    Description:
        Thread class to read a file without freeze the gui
    Constructor:
        importFiebdc.Thread(page, mainWindow,
                     readFileMethod, budget, filename, cancelMethod, filetype)
    Ancestry:
    +--threading.Thread
      +-- importFiebdc.Thread
    Atributes:
        "__page": The page instance that launch the thread
        "__mainWindow": gui.MainWindow instance
        "__readFileMethod": Method to read the selected file
        "__budget
        "__filename": "file"
        "__cancelMethod": Method to cancel the read method
        "__filetype": "budget" or "database"
        "__cancel": Boolean value, True: the thread is stoped
    Methods:
        run()
        cancel()
        isCanceled()
        clear()
    """
    def __init__(self, page, mainWindow, readFileMethod, budget,
                 filename, cancelMethod, filetype):
        """def __init__(page, mainWindow, readFileMethod, budget,
                 filename, cancelMethod, filetype)
        
        page: The page instance that launch the thread
        mainWindow: gui.Mainwindow object
        readFileMethod: Method to read the selected file
        budget: base.Budget object
        filename: "file"
        cancelMethod: Method to cancel the read method
        filetype: "budget" or "database"
        
        Sets the instance atributes.
        """
        super(Thread, self).__init__()
        self.__page = page
        self.__mainWindow = mainWindow
        self.__readFileMethod = readFileMethod
        self.__budget = budget
        self.__filename = filename
        self.__cancelMethod = cancelMethod
        self.__filetype = filetype
        self.__cancel = False

    def run(self):
        """run()
        
        
        """
        self.__readFileMethod(self.__budget, self.__filename, self.__page)
        if not self.__page.endSuccessfully:
            GLib.idle_add(self.__page.threadCanceled)
        else:
            GLib.idle_add(self.__page.threadFinishedSignal, self.__budget)
        self.clear()

    def cancel(self):
        """cancel()
        
        Sets the "__cancel" atribute to True and call "__cancelMethod" to stop
        read the file
        """
        self.__cancel = True
        self.__cancelMethod()

    def isCanceled(self):
        """isCanceled()
        
        Return True if the thread has been canceled
        """
        return self.__cancel
    
    def clear(self):
        del self.__page
        del self.__mainWindow
        del self.__readFileMethod
        del self.__budget
        del self.__filename
        del self.__cancelMethod
        #del self.__cancel
