#!/usr/bin/python
# -*- coding: utf-8 -*-
## File globals.py
## This file is part of pyArq-Presupuestos.
##
## Copyright (C) 2010 Miguel Ángel Bárcena Rodríguez
##                         <miguelangel@obraencurso.es>
##
## pyArq-Presupuestos is free software: you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation, either version 3 of the License, or
## (at your option) any later version.
##
## pyArq-Presupuestos is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program.  If not, see <http://www.gnu.org/licenses/>.

# module for global variables
import os
# path: Paths where find the program files needed

version = "pyArq-Presupuestos v0.0.0"
path = {
    "HOME" : "",
    "APPDATA" : "",
    "ICON" : "/images/pyArq-Presupuestos.svg",
    "CHAPTER-ICON" : "/images/chapter.svg",
    "UNIT-ICON" : "/images/unit.svg",
    "MATERIAL-ICON" : "/images/material.svg",
    "MACHINERY-ICON" : "/images/machinery.svg",
    "LABOURFORCE-ICON": "/images/labourforce.svg",
    "MENU-ICON": "/images/menu.svg",
    "CONNECTED-ICON": "/images/connected.svg",
    "DISCONNECTED-ICON": "/images/disconnected.svg",
    "CLOSE-ICON": "/images/close.svg",
    "DESCRIPTION-ICON": "/images/description.svg",
    "SHEET-ICON": "/images/sheet.svg",
    "DECOMPOSITION-ICON" : "/images/decomposition.svg",
    "MEASURE-ICON" : "/images/measure.svg",
    "ACUMULATEDLINE-ICON" : "/images/acumulatedline.svg",
    "PARCIALLINE-ICON" : "/images/parcialline.svg",
    "NORMALLINE-ICON" : "/images/normalline.svg",
    "CALCULATEDLINE-ICON" : "/images/calculatedline.svg",
    "ARROW-ICON": "/images/arrow.svg",
    "IMAGE-ICON": "/images/image.svg",
    "DXF-ICON": "/images/dxf.svg",
    "DURUS-DATABASE": "/pyArq-Presupuestos/durus/",
    "BUDGET": "/pyArq-Presupuestos/budget/",
    "THROBBER-ICON": "/images/throbber.png",
    "THROBBER-GIF": "/images/throbber.gif",
    "BUDGET-ICON": "/images/budget.svg",
    "PYARQ-ICON": "/images/pyArq.png",
    }

color = {
    "ACTIVE" : "#CDD7FF",           # blue
    "INDEX-EVEN" : "#C4C4C4",       # dark grey
    "INDEX-UNEVEN" : "#DDDDDD",     # grey
    "EVEN" : "#E6E6E6",             # dark white
    "UNEVEN": "#FFFFFF",            # white
    "CHAPTER-EVEN": "#D8E6E6",      # dark cian
    "CHAPTER-UNEVEN": "#F0FFFF",    # cian
    "TEXT": "#000000",              # black
    "CALCULATED-TEXT": "#FF00FF",   # 
    "SUBTOTAL": "#FAC8C8",
    "SUBTOTAL-PARCIAL": "#ADD8E6",
    }
desktop = {
    "autodetect" : True,
    "desktop" : "",
    "browser" : "firefox",
    "mailapp" : "evolution",
    "imageapp" : "gthumb",
    "cadapp" : "qcad",
    }

def getAppPath(key):
    return path["APPDATA"] + path[key]
def getHomePath(key):
    return path["HOME"] + path[key]
if os.name == 'posix':
    path["HOME"] = os.environ.get('HOME')
elif sys.platform == 'win32':
    path["HOME"] = os.environ.get('HOMEPATH')
    # TODO: Mac Os, 
    # TODO: Test in diferents os

#-#
path["BUDGET"] = "/pyArq-Presupuestos/"
#-#
