#!/usr/bin/python
# -*- coding: utf-8 -*-
## File durus.py
## This file is part of pyArq-Presupuestos.
##
## Copyright (C) 2010 Miguel Ángel Bárcena Rodríguez
##                         <miguelangel@obraencurso.es>
##
## pyArq-Presupuestos is free software: you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation, either version 3 of the License, or
## (at your option) any later version.
##
## pyArq-Presupuestos is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Modules
import os.path
# Durus Modules
from durus.file_storage import FileStorage
from durus.connection import Connection

class DurusFile(object):
    def __init__(self, file, new):
        self.__file = file
        if new:
            if os.path.exists(self.__file):
                os.remove(self.__file)
        self.__connection = Connection(FileStorage(self.__file))
        self.__root = self.__connection.get_root()

    def close(self):
        self.__connection.get_storage().close()

    def getBudget(self):
        return self.__root["budget"]

    def setBudget(self, budget):
        self.__root["budget"] = budget
        self.__connection.commit()

