#!/usr/bin/python
# -*- coding: utf-8 -*-
## File openwith.py
## This file is part of pyArq-Presupuestos.
##
## Copyright (C) 2010-2019 Miguel Ángel Bárcena Rodríguez
##                    <miguelangel@obraencurso.es>
##
## This file is based in common/helpers.py from gajim
##
## Copyright (C) 2003-2008 Yann Leboulanger <asterix AT lagaule.org>
## Copyright (C) 2005-2006 Dimitur Kirov <dkirov AT gmail.com>
##                         Nikos Kouremenos <kourem AT gmail.com>
## Copyright (C) 2006 Alex Mauer <hawke AT hawkesnest.net>
## Copyright (C) 2006-2007 Travis Shirk <travis AT pobox.com>
## Copyright (C) 2006-2008 Jean-Marie Traissard <jim AT lapin.org>
## Copyright (C) 2007 Lukas Petrovicky <lukas AT petrovicky.net>
##                    James Newton <redshodan AT gmail.com>
##                    Julien Pivotto <roidelapluie AT gmail.com>
## Copyright (C) 2007-2008 Stephan Erb <steve-e AT h3c.de>
## Copyright (C) 2008 Brendan Taylor <whateley AT gmail.com>
##                    Jonathan Schleifer <js-gajim AT webkeks.org>
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 3 only.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with Gajim. If not, see <http://www.gnu.org/licenses/>.
##
# Modules

# python 2/3 compatibility
from __future__ import absolute_import, division, print_function, unicode_literals

import subprocess
import os
import platform
import sys

# pyArq-Presupuestos modules
from Generic import globalVars

def autodetect_desktop():
    """
    recognize the environment and sets it in globalVars
    os.name:
             python2  'posix', 'nt', 'os2', 'ce', 'java', 'riscos'.
             python3  'posix', 'nt', 'java'.
    sys.platform
              unix: return by uname 
              Linux          'linux', 'linux2'
              Windows        'win32'
              Windows/Cygwin 'cygwin'
              Mac OS X       'darwin'
    """
    if os.name == "nt":
        globalVars.desktop["desktop"] = "windows"
    elif sys.platform == "darwin":
        globalVars.desktop["desktop"] = "macosx"
    elif sys.platform.startswith('linux'):
        globalVars.desktop["desktop"] = "linux"
    else:
        globalVars.desktop["desktop"] = sys.platform

# from common/helpers.py

def exec_command(command):
    subprocess.Popen('%s &' % command, shell=True).wait()

def build_command(executable, parameter):
    # we add to the parameter (can hold path with spaces)
    # "" so we have good parsing from shell
    parameter = parameter.replace('"', '\\"') # but first escape "
    command = '%s "%s"' % (executable, parameter)
    return command

def launch_file(kind, uri):
    """
    kind = "url" ,"mail", "image", "dxf", "wmf", "pdf",  video", 
           "office-document", "office-presentation", "office-spreadsheet",
           "html", "rtf", "txt", ""
    Linux: xdg-open supports:
        Xfce (exo-open "$1"),
        Gnome (gvfs-open "$1", gnome-open "$1" with fallback to generic open),
        KDE (kde-open "$1" with fallback to kfmclient exec "$1"),
        Mate (gvfs-open "$1", mate-open $1),
        LXDE (pcmanfm $1 with fallback to generic open),
        Enlightenment (enlightenment_open $1),
        Cinnamon (open_gnome3 $1, which is gvfs-open "$1" with fallback to generic open),
        Cygwin (cygstart "$1"),
        Darwin (open "$1").
        

    """
    # TODO: test in Mac os X
    # TODO: test in Windows
    # TODO: configured apps in windows?
    
    if kind == "mail" and not uri.startswith("mailto:"):
        uri = "mailto:" + uri
    
    _desktop = globalVars.desktop["desktop"]
    
    if _desktop == "windows":
        try:
            os.startfile(uri) # if pywin32 is installed we open
        except Exception:
            pass
    else:
        # if app is configured in globarVars use it
        if kind in ("url", "html") and globalVars.desktop["browser"] != "":
            command = globalVars.desktop["browser"]
        elif kind == "mail" and globalVars.desktop["mailapp"] != "":
            command = globalVars.desktop["mailapp"]
        elif kind == "image" and globalVars.desktop["imageapp"] != "":
            command = globalVars.desktop["imageapp"]
        elif kind == "wmf" and globalVars.desktop["wmfapp"] != "":
            command = globalVars.desktop["wmfapp"]
        elif kind == "dxf" and globalVars.desktop["cadapp"]  != "":
            command = globalVars.desktop["cadapp"]
        elif kind == "video" and globalVars.desktop["videoapp"]  != "":
            command = globalVars.desktop["videoapp"]
        elif kind in ("office-document", "office-presentation",
                      "office-spreadsheet") and \
             globalVars.desktop["officeapp"]  != "":
            command = globalVars.desktop["officeapp"]
        elif kind == "txt" and globalVars.desktop["txtapp"] != "":
            command = globalVars.desktop["txtapp"]
        elif kind == "rtf" and globalVars.desktop["rtfapp"] != "":
            command = globalVars.desktop["rtfapp"]
        # if no app is configured
        elif _desktop == "macosx":
            command = "open"
        elif _desktop == "linux":
            command = "xdg-open"
        else:
            # if no desktop is detected
            # try xdg-open and cross your fingers 
            command = "xdg-open"

        command = build_command(command, uri)
        try:
            exec_command(command)
        except Exception:
            pass
